/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.common.utils;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtils {
    private static final Logger log = LoggerFactory.getLogger(RSAUtils.class);
    private static final String ALGORITHM = "RSA";
    private static final int KEY_SIZE = 512;
    private static final String PUBLIC_KEY = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAI5aSaPHI2mwTif5zx0t4JdDYHgnftpMq95hDgGPIet4\nr8gKqYfmAkZKmzA79XevgpqXP+syJE1CJQa9LO9rJrcCAwEAAQ==";

    public static KeyPair generateKeyPair() throws Exception {
        KeyPairGenerator gen = KeyPairGenerator.getInstance(ALGORITHM);
        gen.initialize(512);
        return gen.generateKeyPair();
    }

    public static PublicKey getPublicKey(String pubKeyBase64) throws Exception {
        byte[] encPubKey = Base64.getDecoder().decode(pubKeyBase64);
        X509EncodedKeySpec encPubKeySpec = new X509EncodedKeySpec(encPubKey);
        return KeyFactory.getInstance(ALGORITHM).generatePublic(encPubKeySpec);
    }

    public static PrivateKey getPrivateKey(String priKeyBase64) throws Exception {
        byte[] encPriKey = Base64.getDecoder().decode(priKeyBase64);
        PKCS8EncodedKeySpec encPriKeySpec = new PKCS8EncodedKeySpec(encPriKey);
        return KeyFactory.getInstance(ALGORITHM).generatePrivate(encPriKeySpec);
    }

    public static byte[] encrypt(byte[] plainData, PublicKey pubKey) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, pubKey);
        return cipher.doFinal(plainData);
    }

    public static byte[] decrypt(byte[] cipherData, PrivateKey priKey) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, priKey);
        return cipher.doFinal(cipherData);
    }

    public static String clientEncrypt(String data) throws Exception {
        PublicKey pubKey = RSAUtils.getPublicKey(PUBLIC_KEY);
        byte[] cipher = RSAUtils.encrypt(data.getBytes(), pubKey);
        return RSAUtils.toHexString(cipher);
    }

    private static byte[] serverDecrypt(byte[] cipherData, String privateKey) throws Exception {
        PrivateKey priKey = RSAUtils.getPrivateKey(privateKey);
        byte[] plainData = RSAUtils.decrypt(cipherData, priKey);
        return plainData;
    }

    public static byte[] toByteArray(String hexString) {
        if (StringUtils.isEmpty((CharSequence)hexString)) {
            throw new IllegalArgumentException("this hexString must not be empty");
        }
        hexString = hexString.toLowerCase();
        byte[] byteArray = new byte[hexString.length() / 2];
        int k = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            byte high = (byte)(Character.digit(hexString.charAt(k), 16) & 0xFF);
            byte low = (byte)(Character.digit(hexString.charAt(k + 1), 16) & 0xFF);
            byteArray[i] = (byte)(high << 4 | low);
            k += 2;
        }
        return byteArray;
    }

    public static String toHexString(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 1) {
            throw new IllegalArgumentException("this byteArray must not be null or empty");
        }
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            if ((byteArray[i] & 0xFF) < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return hexString.toString().toLowerCase();
    }

    public static String getDecryptValue(String encryptStr, String privateKey) {
        try {
            byte[] plainData = RSAUtils.serverDecrypt(RSAUtils.toByteArray(encryptStr), privateKey);
            return new String(plainData);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            return "";
        }
    }
}

