/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.common.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.annotation.FieldDesc;
import com.kuaike.common.dto.resp.GradeDto;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.enums.EnumConstant;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PojoExport2Excel {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T> void printByAnnotation(List<T> beanList, Class<T> clazz, HttpServletRequest request, HttpServletResponse response, String returnName, String sheetName, List<String> fieldList, boolean isAppendDate, int[] needHideColumns) throws Exception {
        if (StringUtils.isBlank((CharSequence)returnName)) {
            returnName = UUID.randomUUID().toString().replace("-", "");
        }
        if (isAppendDate) {
            Class<PojoExport2Excel> clazz2 = PojoExport2Excel.class;
            // MONITORENTER : cn.kinyun.trade.common.utils.PojoExport2Excel.class
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            Date now = new Date();
            String nowStr = sdf.format(now);
            // MONITOREXIT : clazz2
            returnName = returnName + "-" + nowStr;
        }
        returnName = returnName + ".xlsx";
        PojoExport2Excel.doPrint(beanList, clazz, request, response, returnName, sheetName, fieldList, needHideColumns);
    }

    private static <T> void doPrint(List<T> beanList, Class<T> clazz, HttpServletRequest request, HttpServletResponse response, String returnName, String sheetName, List<String> fieldList, int[] needHideColumns) throws Exception {
        response.reset();
        ServletOutputStream os = response.getOutputStream();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + new String(returnName.getBytes(), StandardCharsets.ISO_8859_1) + "\"");
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(sheetName);
        if (needHideColumns != null) {
            for (int i = 0; i < needHideColumns.length; ++i) {
                sheet.setColumnHidden(needHideColumns[i], true);
            }
        }
        Integer rowNo = 0;
        Integer cellNo = 0;
        PojoExport2Excel.printHeaderAndValue(beanList, clazz, fieldList, wb, (Sheet)sheet, rowNo, cellNo);
        wb.write((OutputStream)os);
        wb.close();
        os.close();
    }

    /*
     * Unable to fully structure code
     */
    private static <T> void printHeaderAndValue(List<T> beanList, Class<T> clazz, List<String> fieldList, XSSFWorkbook wb, Sheet sheet, Integer rowNo, Integer cellNo) throws Exception {
        nCell = null;
        var9_8 = rowNo;
        var10_9 = rowNo = Integer.valueOf(rowNo + 1);
        nRow = sheet.createRow(var9_8.intValue());
        nRow.setHeightInPoints(20.0f);
        headerFieldMap = Maps.newHashMap();
        percentMap = Maps.newHashMap();
        percentLengthMap = Maps.newHashMap();
        dateFormatMap = Maps.newHashMap();
        fields = clazz.getDeclaredFields();
        hasFieldInfo = true;
        if (CollectionUtils.isEmpty(fieldList)) {
            hasFieldInfo = false;
            fieldList = Lists.newArrayList();
        }
        for (Field field : fields) {
            if (field.getType().equals(List.class) || (fieldDesc = field.getDeclaredAnnotation(FieldDesc.class)) == null) continue;
            if (!hasFieldInfo) {
                fieldList.add(fieldDesc.desc());
            }
            headerFieldMap.put(fieldDesc.desc(), field.getName());
            percentMap.put(fieldDesc.desc(), fieldDesc.percent());
            percentLengthMap.put(fieldDesc.desc(), fieldDesc.percentLenth());
            dateFormatMap.put(fieldDesc.desc(), fieldDesc.dateFormat());
        }
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u5b57\u6bb5\u4fe1\u606f");
        }
        headerStyle = PojoExport2Excel.getCellStyle(wb, true);
        contentStyle = PojoExport2Excel.getCellStyle(wb, false);
        lengthMap = Maps.newHashMap();
        for (String fieldName : fieldList) {
            length = fieldName.length() * 4 * 256;
            sheet.setColumnWidth(cellNo.intValue(), length.intValue());
            lengthMap.put(fieldName, length);
            var21_23 = cellNo;
            var22_24 = cellNo = Integer.valueOf(cellNo + 1);
            nCell = nRow.createCell(var21_23.intValue());
            nCell.setCellValue(fieldName);
            nCell.setCellStyle(headerStyle);
        }
        cellNo = 0;
        for (Object t : beanList) {
            length = rowNo;
            rowNo = Integer.valueOf(rowNo + 1);
            var21_23 = rowNo;
            nRow = sheet.createRow(length.intValue());
            valueMap = Maps.newHashMap();
            for (Field field : fields) {
                fieldDesc = field.getDeclaredAnnotation(FieldDesc.class);
                if (fieldDesc == null) continue;
                field.setAccessible(true);
                valueMap.put(fieldDesc.desc(), field.get(t));
            }
            for (String showName : fieldList) {
                nRow.setHeightInPoints(20.0f);
                var23_28 = cellNo;
                field = cellNo = Integer.valueOf(cellNo + 1);
                nCell = nRow.createCell(var23_28.intValue());
                obj = valueMap.get(showName);
                if (obj != null) {
                    percent = (Boolean)percentMap.get(showName);
                    if (percent) {
                        percentLength = (Integer)percentLengthMap.get(showName);
                        number = null;
                        try {
                            number = (Number)obj;
                            if (percentLength == 100) {
                                b = new BigDecimal(number.doubleValue()).divide(new BigDecimal(100)).setScale(2, 4);
                                nCell.setCellValue(b.doubleValue());
                            }
                            if (percentLength != 10000) ** GOTO lbl106
                            b = new BigDecimal(number.doubleValue()).divide(new BigDecimal(10000)).setScale(4, 4);
                            nCell.setCellValue(b.doubleValue());
                        }
                        catch (ClassCastException e) {
                            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9700\u8981\u6253\u5370\u7684\u5b57\u6bb5\u4e0d\u4e3a\u6570\u503c\uff0c\u63cf\u8ff0\u4fe1\u606f\u9519\u8bef");
                        }
                    } else if (obj instanceof IdAndNameDto) {
                        nCell.setCellValue(((IdAndNameDto)obj).getName());
                    } else if (obj instanceof EnumConstant) {
                        nCell.setCellValue(((EnumConstant)obj).getDesc());
                    } else if (obj instanceof Node) {
                        nCell.setCellValue(((Node)obj).getName());
                    } else if (obj instanceof GradeDto) {
                        grade = (GradeDto)obj;
                        if (grade.getGradeId() != -1L) {
                            nCell.setCellValue(grade.getGradeLevelStr() + "(" + grade.getGradeLevelName() + ")");
                        } else {
                            nCell.setCellValue("\u672a\u5b9a\u7ea7");
                        }
                    } else if (obj instanceof Date) {
                        date = (Date)obj;
                        format = dateFormatMap.getOrDefault(showName, "yyyy-MM-dd HH:mm:ss");
                        sdf = new SimpleDateFormat(format);
                        nCell.setCellValue(sdf.format(date));
                    } else if (!(obj instanceof List)) {
                        nCell.setCellValue(obj.toString());
                    }
lbl106:
                    // 12 sources

                    oldMaxLength = (Integer)lengthMap.get(showName);
                    valueLength = obj.toString().length() * 2 * 256;
                    if (obj instanceof Date) {
                        valueLength = 2560;
                    }
                    v0 = maxLength = oldMaxLength > valueLength ? oldMaxLength : valueLength;
                    if (!showName.equals("\u5907\u6ce8") && !showName.equals("\u5185\u5bb9")) {
                        sheet.setColumnWidth(cellNo - 1, maxLength);
                    }
                    lengthMap.put(showName, maxLength);
                }
                nCell.setCellStyle(contentStyle);
            }
            cellNo = 0;
        }
    }

    private static CellStyle getCellStyle(XSSFWorkbook wb, boolean bold) {
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        XSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setBold(bold);
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont((Font)font);
        return cellStyle;
    }
}

