/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.common.utils;

import cn.kinyun.trade.common.utils.RedisDistributedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LockUtil {
    private static final Logger log = LoggerFactory.getLogger(LockUtil.class);
    private static final String prefix = "CRM_JOB_";
    private static RedisDistributedLock redisLock;
    private static final int retry = 10;
    private static final long expireSecs = 60L;
    private static final long sleepMills = 10L;

    @Autowired
    public LockUtil(RedisDistributedLock redisLock) {
        LockUtil.redisLock = redisLock;
    }

    public static boolean tryLock(String classSimpleName) {
        boolean state = false;
        try {
            redisLock.lock(LockUtil.getLockKey(classSimpleName), "", 10, 60L, 10L);
            state = true;
        }
        catch (Exception e) {
            log.error("tryLock error", (Throwable)e);
        }
        return state;
    }

    public static boolean tryLockWithExpireSecs(String classSimpleName, int expireSecs) {
        boolean state = false;
        try {
            redisLock.lock(LockUtil.getLockKey(classSimpleName), "", 10, expireSecs, 10L);
            state = true;
        }
        catch (Exception e) {
            log.error("tryLock error", (Throwable)e);
        }
        return state;
    }

    public static void unLock(String classSimpleName) {
        try {
            redisLock.unlock(LockUtil.getLockKey(classSimpleName));
        }
        catch (Exception e) {
            log.error("unLock error", (Throwable)e);
        }
    }

    private static String getLockKey(String classSimpleName) {
        return prefix + classSimpleName;
    }
}

