/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.common.utils;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DynamicKeyLock<T>
implements Lock {
    private static final ConcurrentHashMap<Object, LockAndCounter> locksMap = new ConcurrentHashMap();
    private final T key;

    public DynamicKeyLock(T lockKey) {
        this.key = lockKey;
    }

    private LockAndCounter newLock() {
        return locksMap.compute(this.key, (key, lockAndCounterInner) -> {
            if (lockAndCounterInner == null) {
                lockAndCounterInner = new LockAndCounter();
            }
            ((LockAndCounter)lockAndCounterInner).counter.incrementAndGet();
            return lockAndCounterInner;
        });
    }

    private void cleanupLock(LockAndCounter lockAndCounterOuter) {
        if (lockAndCounterOuter.counter.decrementAndGet() == 0) {
            locksMap.compute(this.key, (key, lockAndCounterInner) -> {
                if (lockAndCounterInner == null || ((LockAndCounter)lockAndCounterInner).counter.get() == 0) {
                    return null;
                }
                return lockAndCounterInner;
            });
        }
    }

    @Override
    public void lock() {
        LockAndCounter lockAndCounter = this.newLock();
        lockAndCounter.lock.lock();
    }

    @Override
    public void unlock() {
        LockAndCounter lockAndCounter = locksMap.get(this.key);
        lockAndCounter.lock.unlock();
        this.cleanupLock(lockAndCounter);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        LockAndCounter lockAndCounter = this.newLock();
        try {
            lockAndCounter.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            this.cleanupLock(lockAndCounter);
            throw e;
        }
    }

    @Override
    public boolean tryLock() {
        LockAndCounter lockAndCounter = this.newLock();
        boolean acquired = lockAndCounter.lock.tryLock();
        if (!acquired) {
            this.cleanupLock(lockAndCounter);
        }
        return acquired;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        boolean acquired;
        LockAndCounter lockAndCounter = this.newLock();
        try {
            acquired = lockAndCounter.lock.tryLock(time, unit);
        }
        catch (InterruptedException e) {
            this.cleanupLock(lockAndCounter);
            throw e;
        }
        if (!acquired) {
            this.cleanupLock(lockAndCounter);
        }
        return acquired;
    }

    @Override
    public Condition newCondition() {
        LockAndCounter lockAndCounter = locksMap.get(this.key);
        return lockAndCounter.lock.newCondition();
    }

    private static class LockAndCounter {
        private final Lock lock = new ReentrantLock();
        private final AtomicInteger counter = new AtomicInteger(0);

        private LockAndCounter() {
        }
    }
}

