/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.common.utils;

import java.nio.charset.Charset;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class DESUtil {
    public static String encrypt(String srcStr, Charset charset, String sKey) {
        byte[] src = srcStr.getBytes(charset);
        byte[] buf = DESUtil.encrypt(src, sKey);
        return DESUtil.parseByte2HexStr(buf);
    }

    public static String decrypt(String hexStr, Charset charset, String sKey) throws Exception {
        byte[] src = DESUtil.parseHexStr2Byte(hexStr);
        byte[] buf = DESUtil.decrypt(src, sKey);
        return new String(buf, charset);
    }

    public static byte[] encrypt(byte[] data, String sKey) {
        try {
            byte[] key = sKey.getBytes();
            IvParameterSpec iv = new IvParameterSpec(key);
            DESKeySpec desKey = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey securekey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            cipher.init(1, (Key)securekey, iv);
            return cipher.doFinal(data);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decrypt(byte[] src, String sKey) throws Exception {
        byte[] key = sKey.getBytes();
        IvParameterSpec iv = new IvParameterSpec(key);
        DESKeySpec desKey = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(desKey);
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        cipher.init(2, (Key)securekey, iv);
        return cipher.doFinal(src);
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static void main(String[] args) {
        String str = "buId=10&from=wxid_hi2q4bvy63cc22&type=1&to=wxid_rduaeullgead22";
        String key = "buIdTest";
        long startTime = System.currentTimeMillis();
        String encryStr = DESUtil.encrypt(str, Charset.forName("utf8"), key);
        System.out.println(encryStr);
        System.out.println(System.currentTimeMillis() - startTime);
        encryStr = "AAA74ECF70EFDE6B63C84640567FDCC8432611124CEEB12976E97331BE65635A82FE41789FFB8FDF36E82E0B61951391BDC7A9B78009F1AC7618867503B37";
        try {
            startTime = System.currentTimeMillis();
            System.out.println(DESUtil.decrypt(encryStr, Charset.forName("utf8"), key));
            System.out.println(System.currentTimeMillis() - startTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

