/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.common.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppTokenUtil {
    private static final Logger log = LoggerFactory.getLogger(AppTokenUtil.class);

    public static String initToken(String name) {
        DefaultHashService hashService = new DefaultHashService();
        hashService.setPrivateSalt(ByteSource.Util.bytes((String)"."));
        hashService.setHashAlgorithmName("MD5");
        hashService.setHashIterations(2);
        HashRequest request = new HashRequest.Builder().setSalt((Object)name).setSource((Object)String.valueOf(new Date().getTime())).build();
        String res = hashService.computeHash(request).toHex();
        return res;
    }

    public static String initJwtToken(String name) {
        Date now = new Date();
        String token = JWT.create().withHeader((Map)ImmutableMap.of((Object)"alg", (Object)"HS256", (Object)"typ", (Object)"JWT")).withClaim("username", name).withIssuer("zxq").withSubject("zxq jwt token").withNotBefore(now).withAudience(new String[]{"zxq app"}).withIssuedAt(now).withExpiresAt(DateUtils.addDays((Date)now, (int)30)).sign(Algorithm.HMAC256((String)"101dac56-83cc-4224-be82-0ecee5477441"));
        return token;
    }

    public static boolean verifyJwtToken(String token) {
        boolean pass = true;
        try {
            JWT.require((Algorithm)Algorithm.HMAC256((String)"101dac56-83cc-4224-be82-0ecee5477441")).withIssuer("zxq").build().verify(token);
        }
        catch (Exception ex) {
            log.info("token:{}\u5931\u6548,\u9700\u4ece\u65b0\u767b\u9646,{}", (Object)token, (Object)ex.getMessage());
            pass = false;
        }
        return pass;
    }

    public static String drawJwtTokenUserName(String token) {
        return JWT.decode((String)token).getClaim("username").asString();
    }

    public static void main(String[] args) {
        System.out.println(AppTokenUtil.drawJwtTokenUserName("eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiJ6e\nHEgand0IHRva2VuIiwiYXVkIjoienhxIGFwcCIsIm5iZiI6MTYwNzMwOTc2NSwiaXNzIjoienhxIiwiZXhwIjoxNjA5OTAxNzY1LCJpYXQiOjE2MDczMDk3NjUsInVzZXJuYW1lIjoianVuIn0.EWSW6B2rkH-01j-CrX\n9kKIvnR422AKqUBWbiAdlipn8"));
    }
}

