/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.common.service.dto.resp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class OrgListRespDto {
    private Long id;
    private List<Long> ids;
    private String name;
    private Integer weworkOrgId;
    private Long pid;
    private Boolean disabled;
    private List<OrgListRespDto> children;

    public static List<OrgListRespDto> buildNodeTrees(List<OrgListRespDto> nodes) {
        ArrayList nodeTrees = Lists.newArrayList();
        if (CollectionUtils.isEmpty(nodes)) {
            return nodeTrees;
        }
        Map map = nodes.stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        for (OrgListRespDto node : nodes) {
            if (!map.containsKey(node.getPid())) {
                nodeTrees.add(node);
                continue;
            }
            OrgListRespDto parent = (OrgListRespDto)map.get(node.getPid());
            if (parent.getChildren() == null) {
                parent.setChildren(Lists.newArrayList());
            }
            parent.getChildren().add(node);
        }
        for (OrgListRespDto node : nodes) {
            if (map.containsKey(node.getPid())) continue;
            OrgListRespDto.buildIdAndNames(node, null, null);
        }
        return nodeTrees;
    }

    public static List<OrgListRespDto> buildPartOrgNodeTrees(List<OrgListRespDto> nodes) {
        ArrayList nodeTrees = Lists.newArrayList();
        if (CollectionUtils.isEmpty(nodes)) {
            return nodeTrees;
        }
        Map map = nodes.stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        for (OrgListRespDto node : nodes) {
            if (!map.containsKey(node.getPid())) {
                nodeTrees.add(node);
                continue;
            }
            OrgListRespDto parent = map.getOrDefault(node.getPid(), null);
            if (parent == null) continue;
            if (parent.getChildren() == null) {
                parent.setChildren(Lists.newArrayList());
            }
            parent.getChildren().add(node);
        }
        for (OrgListRespDto node : nodes) {
            if (map.containsKey(node.getPid())) continue;
            OrgListRespDto.buildIdAndNames(node, null, null);
        }
        return nodeTrees;
    }

    private static void buildIdAndNames(OrgListRespDto node, List<Long> parentIds, List<String> parentNames) {
        ArrayList ids = Lists.newArrayList();
        ArrayList names = Lists.newArrayList();
        node.setIds(ids);
        if (parentIds != null) {
            ids.addAll(parentIds);
            names.addAll(parentNames);
        }
        ids.add(node.getId());
        names.add(node.getName());
        if (CollectionUtils.isNotEmpty(node.getChildren())) {
            for (OrgListRespDto child : node.getChildren()) {
                OrgListRespDto.buildIdAndNames(child, ids, names);
            }
        }
    }

    public Long getId() {
        return this.id;
    }

    public List<Long> getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public Integer getWeworkOrgId() {
        return this.weworkOrgId;
    }

    public Long getPid() {
        return this.pid;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public List<OrgListRespDto> getChildren() {
        return this.children;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWeworkOrgId(Integer weworkOrgId) {
        this.weworkOrgId = weworkOrgId;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public void setChildren(List<OrgListRespDto> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgListRespDto)) {
            return false;
        }
        OrgListRespDto other = (OrgListRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$weworkOrgId = this.getWeworkOrgId();
        Integer other$weworkOrgId = other.getWeworkOrgId();
        if (this$weworkOrgId == null ? other$weworkOrgId != null : !((Object)this$weworkOrgId).equals(other$weworkOrgId)) {
            return false;
        }
        Long this$pid = this.getPid();
        Long other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !((Object)this$pid).equals(other$pid)) {
            return false;
        }
        Boolean this$disabled = this.getDisabled();
        Boolean other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        List<Long> this$ids = this.getIds();
        List<Long> other$ids = other.getIds();
        if (this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<OrgListRespDto> this$children = this.getChildren();
        List<OrgListRespDto> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrgListRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $weworkOrgId = this.getWeworkOrgId();
        result = result * 59 + ($weworkOrgId == null ? 43 : ((Object)$weworkOrgId).hashCode());
        Long $pid = this.getPid();
        result = result * 59 + ($pid == null ? 43 : ((Object)$pid).hashCode());
        Boolean $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        List<Long> $ids = this.getIds();
        result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<OrgListRespDto> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "OrgListRespDto(id=" + this.getId() + ", ids=" + this.getIds() + ", name=" + this.getName() + ", weworkOrgId=" + this.getWeworkOrgId() + ", pid=" + this.getPid() + ", disabled=" + this.getDisabled() + ", children=" + this.getChildren() + ")";
    }
}

