/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.common.config;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CuratorFrameworkConfig {
    private int sessionTimeoutMs = 120000;
    private int connectionTimeoutMs = 30000;
    @Value(value="${spring.cloud.zookeeper.connect-string}")
    String zkHostConnectString;

    @Bean(destroyMethod="close")
    public CuratorFramework curatorFramework() {
        RetryForever retryPolicy = new RetryForever(3000);
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(this.zkHostConnectString).sessionTimeoutMs(this.sessionTimeoutMs).connectionTimeoutMs(this.connectionTimeoutMs).retryPolicy((RetryPolicy)retryPolicy).build();
        curatorFramework.start();
        return curatorFramework;
    }
}

