/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.common.component;

import cn.kinyun.trade.common.dto.CascadeEnumDto;
import cn.kinyun.trade.common.enums.EnumService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EnumServices {
    private static final Logger log = LoggerFactory.getLogger(EnumServices.class);
    private final String basePackageInSlash = "cn/kinyun/trade/common/enums";
    private final String basePackageInDots = "cn/kinyun/trade/common/enums".replace("/", ".");
    private volatile Map<String, List> enumMap = new HashMap<String, List>();

    @PostConstruct
    private void init() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> urls = cl.getResources("cn/kinyun/trade/common/enums");
        HashMap tempEnumMap = Maps.newHashMap();
        while (urls.hasMoreElements()) {
            File enumFilesDir;
            URL url = urls.nextElement();
            String protocol = url.getProtocol();
            if ("jar".equalsIgnoreCase(protocol)) {
                JarFile jarFile;
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                if (connection == null || (jarFile = connection.getJarFile()) == null) continue;
                Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
                while (jarEntryEnumeration.hasMoreElements()) {
                    String className;
                    Class<?> cls;
                    JarEntry entry = jarEntryEnumeration.nextElement();
                    String jarEntryName = entry.getName();
                    if (!jarEntryName.contains(".class") || !jarEntryName.replaceAll("/", ".").startsWith(this.basePackageInDots) || !(cls = Class.forName(className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replace("/", "."))).isEnum()) continue;
                    this.transfer(cls, tempEnumMap);
                }
                continue;
            }
            if (!"file".equalsIgnoreCase(protocol) || !(enumFilesDir = new File(url.getFile())).isDirectory()) continue;
            for (File file : Objects.requireNonNull(enumFilesDir.listFiles())) {
                Class<?> cls = Class.forName(this.basePackageInDots + "." + file.getName().replaceAll(".class$", ""));
                if (!cls.isEnum()) continue;
                this.transfer(cls, tempEnumMap);
            }
        }
        this.enumMap = tempEnumMap;
    }

    private void transfer(Class cls, Map<String, List> tempEnumMap) {
        String enumName = cls.getSimpleName().replaceFirst("Enum$", "");
        enumName = StringUtils.uncapitalize((String)enumName);
        List enumList = tempEnumMap.getOrDefault(enumName, new ArrayList());
        for (Object e : cls.getEnumConstants()) {
            if (!(e instanceof EnumService)) continue;
            EnumService enumService = (EnumService)e;
            enumList.add(new CascadeEnumDto(Long.valueOf(enumService.getValue()), enumService.getDesc(), Collections.emptyList()));
        }
        tempEnumMap.put(enumName, (List)ImmutableList.copyOf((Collection)enumList));
    }

    public Map<String, List> getEnumMap() {
        return this.enumMap;
    }
}

