/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.pay.business.dto.request;

import cn.kinyun.pay.business.dto.request.PayCertBase64Dto;
import cn.kinyun.pay.business.dto.request.PayConfigBaseReq;
import cn.kinyun.pay.business.enums.PayChannelCode;
import cn.kinyun.pay.business.enums.PayChannelType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PayConfigModReq
extends PayConfigBaseReq
implements Serializable {
    private String num;
    private String mchName;
    private String secret;
    private String alipayAppPrivateKey;
    private List<PayCertBase64Dto> payCerts;
    private Long operatorId;
    private static final Set<String> WEIXIN_CERT_NAMES = Sets.newHashSet((Object[])new String[]{"apiclient_cert.p12", "apiclient_cert.pem", "apiclient_key.pem"});
    private static final Set<String> ALIPAY_CERT_NAMES = Sets.newHashSet((Object[])new String[]{"alipayCertPublicKey_RSA2.crt", "alipayRootCert.crt"});
    private static final Pattern PATTERN = Pattern.compile("\\d{5,}");

    /*
     * WARNING - void declaration
     */
    public void validate(Integer payChannelType, String appId) {
        super.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.num), (Object)"num can not be null or empty");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.mchName) || StringUtils.isNotBlank((CharSequence)this.secret) || !CollectionUtils.isEmpty(this.payCerts) || StringUtils.isNotBlank((CharSequence)this.alipayAppPrivateKey) ? 1 : 0) != 0, (Object)"mchName and secret and payCert and alipayAppPrivateKey can not be null or empty at same time");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.operatorId), (Object)"operatorId \u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)this.secret) && Objects.equals(PayChannelType.get(payChannelType).getServiceCode(), PayChannelCode.PAY_CHANNEL_CODE_WEIXIN.getValue())) {
            Preconditions.checkArgument((StringUtils.length((CharSequence)this.secret) == 32 ? 1 : 0) != 0, (Object)"\u5fae\u4fe1\u652f\u4ed8\u79d8\u94a5secret\u4e3a32\u4f4d\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StringUtils.isNotBlank((CharSequence)this.alipayAppPrivateKey) && Objects.equals(PayChannelType.get(payChannelType).getServiceCode(), PayChannelCode.PAY_CHANNEL_CODE_ALIPAY.getValue())) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.alipayAppPrivateKey), (Object)"alipayAppPrivateKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isNotEmpty(this.payCerts)) {
            Set fileNames;
            Collection notMatchFileNames;
            if (Objects.equals(PayChannelType.get(payChannelType).getServiceCode(), PayChannelCode.PAY_CHANNEL_CODE_WEIXIN.getValue())) {
                Preconditions.checkArgument((CollectionUtils.size(this.payCerts) == 3 ? 1 : 0) != 0, (Object)"\u5fae\u4fe1\u652f\u4ed8\u8bc1\u4e66\u67093\u4e2a\u6587\u4ef6");
            } else if (Objects.equals(PayChannelType.get(payChannelType).getServiceCode(), PayChannelCode.PAY_CHANNEL_CODE_ALIPAY.getValue())) {
                Preconditions.checkArgument((CollectionUtils.size(this.payCerts) == 3 ? 1 : 0) != 0, (Object)"\u652f\u4ed8\u5b9d\u652f\u4ed8\u8bc1\u4e66\u67093\u4e2a\u6587\u4ef6");
            }
            for (PayCertBase64Dto payCert : this.payCerts) {
                payCert.validate();
            }
            if (PayChannelType.get(payChannelType).getServiceCode().equals(PayChannelCode.PAY_CHANNEL_CODE_ALIPAY.getValue())) {
                void var6_13;
                Map fileName2Dto = this.payCerts.stream().collect(Collectors.toMap(PayCertBase64Dto::getCertName, Function.identity()));
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : ALIPAY_CERT_NAMES) {
                    PayCertBase64Dto dto = (PayCertBase64Dto)fileName2Dto.get(string);
                    if (!Objects.isNull(dto)) continue;
                    stringBuilder.append(string).append(',');
                }
                boolean findAppCertPublicKey = false;
                for (PayCertBase64Dto payCert : this.payCerts) {
                    if (!payCert.getCertName().matches("appCertPublicKey_\\d+\\.crt")) continue;
                    findAppCertPublicKey = true;
                    Matcher matcher = PATTERN.matcher(payCert.getCertName());
                    if (!matcher.find()) continue;
                    Preconditions.checkArgument((boolean)StringUtils.equals((CharSequence)matcher.group(), (CharSequence)appId), (Object)"\u652f\u4ed8\u5b9d\u5e94\u7528\u516c\u94a5\u8bc1\u4e66\u548cappId\u4e0d\u5339\u914d");
                }
                if (!findAppCertPublicKey) {
                    stringBuilder.append("appCertPublicKey_xxxxxx.crt").append(',');
                }
                String string = "";
                if (StringUtils.isNotBlank((CharSequence)stringBuilder.toString())) {
                    String string3 = stringBuilder.substring(0, stringBuilder.length() - 1);
                    string3 = string3 + "\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5";
                }
                Preconditions.checkArgument((boolean)StringUtils.isEmpty((CharSequence)var6_13), (Object)var6_13);
            }
            if (PayChannelType.get(payChannelType).getServiceCode().equals(PayChannelCode.PAY_CHANNEL_CODE_WEIXIN.getValue()) && CollectionUtils.isNotEmpty((Collection)(notMatchFileNames = CollectionUtils.subtract(WEIXIN_CERT_NAMES, fileNames = this.payCerts.stream().map(PayCertBase64Dto::getCertName).collect(Collectors.toSet()))))) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String notMatchFileName : notMatchFileNames) {
                    stringBuilder.append(notMatchFileName).append(',');
                }
                String string = stringBuilder.substring(0, stringBuilder.length() - 1);
                Preconditions.checkArgument((boolean)StringUtils.isEmpty((CharSequence)string), (Object)(string + "\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            }
        }
    }

    public String findAlipayAppCert(Integer payChannelType) {
        String appCertName = null;
        if (PayChannelType.get(payChannelType).getServiceCode().equals(PayChannelCode.PAY_CHANNEL_CODE_ALIPAY.getValue())) {
            for (PayCertBase64Dto payCert : this.payCerts) {
                if (!payCert.getCertName().matches("appCertPublicKey_\\d+\\.crt")) continue;
                appCertName = payCert.getCertName();
            }
        }
        return appCertName;
    }

    public String getNum() {
        return this.num;
    }

    public String getMchName() {
        return this.mchName;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getAlipayAppPrivateKey() {
        return this.alipayAppPrivateKey;
    }

    public List<PayCertBase64Dto> getPayCerts() {
        return this.payCerts;
    }

    public Long getOperatorId() {
        return this.operatorId;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setMchName(String mchName) {
        this.mchName = mchName;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setAlipayAppPrivateKey(String alipayAppPrivateKey) {
        this.alipayAppPrivateKey = alipayAppPrivateKey;
    }

    public void setPayCerts(List<PayCertBase64Dto> payCerts) {
        this.payCerts = payCerts;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayConfigModReq)) {
            return false;
        }
        PayConfigModReq other = (PayConfigModReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$operatorId = this.getOperatorId();
        Long other$operatorId = other.getOperatorId();
        if (this$operatorId == null ? other$operatorId != null : !((Object)this$operatorId).equals(other$operatorId)) {
            return false;
        }
        String this$num = this.getNum();
        String other$num = other.getNum();
        if (this$num == null ? other$num != null : !this$num.equals(other$num)) {
            return false;
        }
        String this$mchName = this.getMchName();
        String other$mchName = other.getMchName();
        if (this$mchName == null ? other$mchName != null : !this$mchName.equals(other$mchName)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$alipayAppPrivateKey = this.getAlipayAppPrivateKey();
        String other$alipayAppPrivateKey = other.getAlipayAppPrivateKey();
        if (this$alipayAppPrivateKey == null ? other$alipayAppPrivateKey != null : !this$alipayAppPrivateKey.equals(other$alipayAppPrivateKey)) {
            return false;
        }
        List<PayCertBase64Dto> this$payCerts = this.getPayCerts();
        List<PayCertBase64Dto> other$payCerts = other.getPayCerts();
        return !(this$payCerts == null ? other$payCerts != null : !((Object)this$payCerts).equals(other$payCerts));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PayConfigModReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $operatorId = this.getOperatorId();
        result = result * 59 + ($operatorId == null ? 43 : ((Object)$operatorId).hashCode());
        String $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : $num.hashCode());
        String $mchName = this.getMchName();
        result = result * 59 + ($mchName == null ? 43 : $mchName.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $alipayAppPrivateKey = this.getAlipayAppPrivateKey();
        result = result * 59 + ($alipayAppPrivateKey == null ? 43 : $alipayAppPrivateKey.hashCode());
        List<PayCertBase64Dto> $payCerts = this.getPayCerts();
        result = result * 59 + ($payCerts == null ? 43 : ((Object)$payCerts).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PayConfigModReq(num=" + this.getNum() + ", mchName=" + this.getMchName() + ", secret=" + this.getSecret() + ", alipayAppPrivateKey=" + this.getAlipayAppPrivateKey() + ", payCerts=" + this.getPayCerts() + ", operatorId=" + this.getOperatorId() + ")";
    }
}

