package cn.kinyun.pay.business.status;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum RefundHeaderStatus {

    REFUND_MARK_DEAL(-3,"标记为已付"),

    REFUND_REJECT(-2,"退款拒绝"),

    REFUND_WAIT_AUDIT(-1,"退款待审计"),

	REFUND_INIT(10, "订单待处理"),

    REFUND_ING(1, "订单处理中"),

    REFUND_SUCCESS(2, "全部成功"),

    REFUND_FAIL(3, "全部失败"),

    REFUND_PARTIAL_ING(4, "部分成功"),

    REFUND_PARTIAL_COMPLETE(5, "部分成功完成"),

    REFUND_TERMINATE(6,"退款终止(不可自动转换为转账的,需要人工介入确定状态)"),
    ;

    private int value;

    private String desc;

    private static Map<Integer, RefundHeaderStatus> MAP;

    static {
        MAP = Arrays.stream(RefundHeaderStatus.values()).collect(Collectors.toMap(RefundHeaderStatus::getValue, e -> e));
    }

    RefundHeaderStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static RefundHeaderStatus get(Integer value) {
        return MAP.get(value);
    }

}
