package cn.kinyun.pay.business.status;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum RefundBatchStatus {

    INIT(0, "初始化"),

    REFUNDING(1, "进行中"),

    FINISH(2,"完成"),


    ;

    private Integer status;

    private String desc;

    RefundBatchStatus(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, RefundBatchStatus> MAP;

    static {
        MAP = Arrays.stream(RefundBatchStatus.values()).collect(Collectors.toMap(a -> a.getStatus(), a -> a));
    }

    public static RefundBatchStatus getByStatus(Integer status) {
        return MAP.get(status);
    }
}
