package cn.kinyun.pay.business.status;

import com.google.common.collect.ImmutableMap;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum OrderStatus {
    UNPAID(1, "未支付"),

    PAID(2, "已支付"),

    CLOSED(3, "已关闭");

    private Integer value;

    private String desc;

    static Map<Integer, OrderStatus> MAP;

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(OrderStatus.values()).collect(Collectors.toMap(OrderStatus::getValue, e -> e)));
    }

    OrderStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static OrderStatus get(Integer value) {
        return MAP.get(value);
    }
    }
