package cn.kinyun.pay.business.service;

import cn.kinyun.pay.business.dto.request.TransQueryRequest;
import cn.kinyun.pay.business.dto.response.TransQueryResp;
import cn.kinyun.pay.business.dto.request.TransRequest;
import cn.kinyun.pay.business.dto.response.BaseResponse;

public interface PayTransService {

    /**
     * 转账接口
     *
     * @param transRequest
     * @return
     */
    BaseResponse trans(TransRequest transRequest);

    /**
     * 根据corpId查询商户可用的转账appId
     * @param corpId
     * @return
     */
    BaseResponse<String> queryAvailableAppId(String corpId);

    /**
     * 转账查询接口
     *
     * @param transQueryRequest
     * @return
     */
    BaseResponse<TransQueryResp> queryTrans(TransQueryRequest transQueryRequest);
}
