package cn.kinyun.pay.business.service;

import cn.kinyun.pay.business.dto.request.RefundOrTransRequest;
import cn.kinyun.pay.business.dto.request.RefundOrderReq;
import cn.kinyun.pay.business.dto.request.RefundQueryReq;
import cn.kinyun.pay.business.dto.request.RefundRequest;
import cn.kinyun.pay.business.dto.request.trans.TransTargetInfoReq;
import cn.kinyun.pay.business.dto.response.BaseResponse;
import cn.kinyun.pay.business.dto.response.RefundOrderResp;
import cn.kinyun.pay.business.dto.response.RefundQueryResp;

/**
 * Created by titengjiang on 2021/8/31
 */
public interface PayRefundService {
    /**
     * 退款接口, 建议使用refundOrTrans
     *
     * @param refundRequest
     * @return
     */
    @Deprecated
    BaseResponse refund(RefundRequest refundRequest);

    /**
     * 优先原路退回,不成功转转账接口(转退一体)
     *
     * @param refundOrTransRequest
     * @return
     */
    BaseResponse refundOrTrans(RefundOrTransRequest refundOrTransRequest);

    /**
     * 当收款账户错误时, 更新收款账号信息
     *
     * @param transTargetInfoReq
     * @return
     */
    BaseResponse updateTransTargetInfo(TransTargetInfoReq transTargetInfoReq);

    /**
     * 查询订单退款信息（包含退款和转账信息）
     * @param req
     * @return
     */
    BaseResponse<RefundQueryResp> queryRefund(RefundQueryReq req);


    /**
     * 查询退款单信息
     * @param req
     * @return
     */
    BaseResponse<RefundOrderResp> queryRefundOrder(RefundOrderReq req);
}
