package cn.kinyun.pay.business.service;

import cn.kinyun.pay.business.dto.request.CertValidReq;
import cn.kinyun.pay.business.dto.response.BaseResponse;
import cn.kinyun.pay.business.dto.response.CertResponse;

public interface PayInnerCertService {

    /**
     * 获取当前证书
     *
     * @return
     */
    BaseResponse<CertResponse> queryCurrentCert();

    /**
     * 客户端判断本地读取的私钥是否正确
     * 提交参数为私钥计算出的公钥
     */
    BaseResponse<Boolean> certValid(CertValidReq req);

    /**
     * 根据corp查询appId
     *
     * @param corpId
     * @return
     */
    BaseResponse<String> queryAppId(String corpId);
}
