package cn.kinyun.pay.business.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by jiangtiteng on 2021/9/11
 */
public enum PayChannelCode {
    PAY_CHANNEL_CODE_WEIXIN("weixin", "微信"),
    PAY_CHANNEL_CODE_ALIPAY("alipay", "支付宝"),
    PAY_CHANNEL_CODE_OFFLINE("offline", "线下")
    ;

    private String value;

    private String desc;

    PayChannelCode(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, PayChannelCode> MAP;

    static {
        MAP = Arrays.stream(PayChannelCode.values()).collect(Collectors.toMap(a -> a.getValue(), a -> a));
    }

    public static PayChannelCode get(String value) {
        return MAP.get(value);
    }
}
