package cn.kinyun.pay.business.dto.request.trans;

import cn.kinyun.pay.business.dto.request.BaseRequest;
import cn.kinyun.pay.business.enums.PayTransChannelType;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 用于转账失败时,更新收款人信息
 */
@Data
public class TransTargetInfoReq extends BaseRequest {

    /**
     * 业务订单号，退转一体类型必传，转账类型必须为空
     */
    private String bizOrderNum;
    /**
     * 业务转账单号，纯转账类型必传，退转一体必须为空
     */
    private String bizTransNum;

    /**
     * 转账类型
     * <p>
     * 取值为: {@link cn.kinyun.pay.business.enums.PayTransChannelType}
     */
    private Integer payTransType;

    private AliPayAccount accountInfo;

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument(StringUtils.isNotBlank(bizOrderNum) || StringUtils.isNotBlank(bizTransNum), "bizOrderNum, bizTransNum不能同时为空");
        Preconditions.checkArgument(Objects.nonNull(payTransType) && PayTransChannelType.get(payTransType) != null, "payTransType转账类型不能为空");
        Preconditions.checkArgument(Objects.nonNull(accountInfo), "accountInfo不能为空");
        accountInfo.validate();
    }
}
