package cn.kinyun.pay.business.dto.request.audit.refund;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@SuppressWarnings({"common-java:DuplicatedBlocks"})
@Data
public class RefundListItem implements Serializable {

    private String appId;
    /**
     * 退款headerId
     */
    private Long refundHeaderId;
    /**
     * 订单编号
     */
    private String bizOrderNum;
    /**
     * 退款单号
     */
    private String bizRefundNum;
    /**
     * 订单中心退款单号
     */
    private String refundNum;
    /**
     * 第三方退款单号
     */
    private List<String> refundSeqs;
    /**
     * 退款金额(元)
     */
    private BigDecimal totalAmount;
    /**
     * 待退款金额(元)
     */
    private BigDecimal needAmount;

    /**
     * 实退金额(元)
     */
    private BigDecimal successAmount;

    /**
     * 退款方式
     * 支付宝转账,原路退回,银行转账等等
     */
    private Integer refundType;
    /**
     * 银行卡号
     */
    private String cardNo;
    /**
     * 数据来源
     * 商品订单, 出纳导入 等
     */
    private String sourceType;
    /**
     * 出纳人
     */
    private Long operatorId;

    private String operatorName;
    /**
     * 批次号
     */
    private String batchNum;

    private Date createTime;
    /**
     * 退款单状态
     */
    private Integer status;
    /**
     * 退款单状态描述
     */
    private String statusDesc;
}
