package cn.kinyun.pay.business.dto.request;

import cn.kinyun.pay.business.dto.request.trans.AliPayAccount;
import cn.kinyun.pay.business.enums.PayTransChannelType;
import com.google.common.base.Preconditions;
import lombok.Data;

import java.util.Objects;

@Data
public class RefundOrTransRequest extends RefundRequest {
    /**
     * 转账类型
     *
     * 取值为: {@link PayTransChannelType}
     */
    private Integer payTransType;

    /**
     * 转账账户，根据支付方式不同区分
     */
    private AliPayAccount accountInfo;

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument(Objects.nonNull(payTransType) && PayTransChannelType.get(payTransType) != null, "转账类型不能为空");
        Preconditions.checkArgument(Objects.nonNull(accountInfo), "转账账户不能为空");
        accountInfo.validate();
    }
}
