package cn.kinyun.pay.business.dto.request;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

@Data
public class PayConfigSwitchReq extends PayConfigBaseReq implements Serializable {

    private String num;

    private Integer enable;

    public void validate() {
        super.validate();
        Preconditions.checkArgument(StringUtils.isNotBlank(num), "num is null or empty");
        Preconditions.checkArgument(Objects.nonNull(enable) && enable >= 0 && enable <= 1, "enable should between 0 and 1");
    }
}
