package cn.kinyun.pay.business.dto.request;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class PayCertBase64Dto implements Serializable {

    private String certBase64;

    private String certName;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(certBase64), "certBase64不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(certName), "certName不能为空");
        if (StringUtils.contains(certBase64, ";base64,")) {
            String[] arr = certBase64.split(";base64,");
            if (ArrayUtils.getLength(arr) == 2) {
                certBase64 = arr[1];
            }
        }
    }
}
