package cn.kinyun.pay.business.dto.request;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class OrderQuerySimpleRequest implements Serializable {

    /**
     * 支付单号
     */
    private String orderNum;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(orderNum), "orderNum不能同时为空");
    }
}
