/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.pay.business.component;

import cn.kinyun.pay.business.dto.request.CertValidReq;
import cn.kinyun.pay.business.dto.response.BaseResponse;
import cn.kinyun.pay.business.dto.response.CertResponse;
import cn.kinyun.pay.business.service.PayInnerCertService;
import cn.kinyun.pay.business.utils.DigitalSignatureUtil;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayCertBackgroundService {
    private static final Logger log = LoggerFactory.getLogger(PayCertBackgroundService.class);
    @Autowired(required=false)
    private PayInnerCertService certService;
    private static String privateKey;
    private static final ScheduledExecutorService EXECUTOR_SERVICE;

    @PostConstruct
    public void init() {
        EXECUTOR_SERVICE.scheduleWithFixedDelay(() -> {
            if (Objects.isNull(this.certService)) {
                log.info("certService is null,return");
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)privateKey)) {
                CertValidReq req = new CertValidReq();
                try {
                    req.setPublicKey(DigitalSignatureUtil.calPublicKeyFromPrivateKey(privateKey));
                    BaseResponse<Boolean> response = this.certService.certValid(req);
                    if (response.isSuccess() && response.getData().booleanValue()) {
                        log.info("check cert success");
                        return;
                    }
                }
                catch (Exception e) {
                    log.error("cal cert fail,", (Throwable)e);
                }
            }
            this.reloadPrivateKey();
        }, 20L, 300L, TimeUnit.SECONDS);
        log.info("payCertBackgroundService start");
    }

    public void reloadPrivateKey() {
        BaseResponse<CertResponse> certResponse = this.certService.queryCurrentCert();
        if (certResponse.isSuccess()) {
            privateKey = certResponse.getData().getPrivateKey();
        }
    }

    public String getSign(Object req) {
        while (StringUtils.isEmpty((CharSequence)privateKey)) {
            this.reloadPrivateKey();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.error("error: ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return DigitalSignatureUtil.signFromSha1WithRSA(req, privateKey);
    }

    static {
        EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor();
    }
}

