package cn.kinyun.pay.business.status;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by jiangtiteng on 2019-01-03
 */
public enum OrderHeaderStatus {
    PAYING(1, "支付中"),

    PAID(2, "支付完成"),

    PARTIAL(3, "部分完成");

    private int value;

    private String desc;

    private static Map<Integer, OrderHeaderStatus> MAP;

    static {
       MAP = Arrays.stream(OrderHeaderStatus.values()).collect(Collectors.toMap(OrderHeaderStatus::getValue, e -> e));
    }

    OrderHeaderStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static OrderHeaderStatus get(Integer value) {
        return MAP.get(value);
    }
}


