package cn.kinyun.pay.business.service;

import cn.kinyun.pay.business.dto.request.*;
import cn.kinyun.pay.business.dto.response.*;

import java.util.List;

/**
 * author: jw
 * date: 2022/4/29 下午5:33
 * content: scrm支付配置同步到支付中心
 */
public interface ScrmPayConfigService {
    @Deprecated
    String setConfig(ScrmPayConfigDto params);

    /**
     * 查询支付配置(带分组)
     *
     * @param req
     * @return
     */
    PayConfigListResp queryConfigList(PayConfigListReq req);


    /**
     * 查询支付配置列表
     * @param req
     * @return
     */
    PayConfigPlainListResp queryConfigPlainList(PayConfigListReq req);

    /**
     * 添加支付配置
     *
     * @param req
     */
    void addConfig(PayConfigAddReq req);

    /**
     * 修改支付配置
     * @param req
     */
    void modConfig(PayConfigModReq req);

    /**
     * 支付配置切换
     *
     * @param req
     */
    void switchEnable(PayConfigSwitchReq req);

    /**
     * 编辑配置分组（新增，编辑）
     * @param req
     */
    void editConfigGroup(PayConfigGroupAddReq req);

    /**
     * 删除分组
     * @param req
     */
    void deleteConfigGroup(PayConfigGroupReq req);

    /**
     * 查询商户的group key
     * @param req
     * @return
     */
    PayConfigGroupDtoResp queryConfigGroup(PayConfigGroupQuery req);

    /**
     * 根据groupKey查询明细
     * @param req
     * @return
     */
    PayConfigGroupItemResp queryConfigGroupItems(PayConfigGroupReq req);

    /**
     * 获取商户默认主体支付配置
     * @param req
     * @return
     */
    List<PayConfigGroupItem> queryDefaultConfigGroupItems(PayConfigBaseReq req);

    /**
     * 获取商户默认支付主体groupKey
     * @param req
     * @return
     */
    String getDefaultGroupKey(PayConfigBaseReq req);
}
