package cn.kinyun.pay.business.service;

import cn.kinyun.pay.business.dto.request.audit.trans.*;

import java.util.List;

public interface PayTransAuditService {
    /**
     * 查询转账列表
     * @param req
     * @return
     */
    TransListQueryResp queryList(TransListQueryReq req);

    /**
     * 计算选择的转账记录之和
     * @param req
     * @return
     */
    TransCalDto queryCal(TransListCalReq req);

    /**
     * 手动提交转账
     * @param req
     */
    void submitTrans(ManualTransReq req);

    /**
     * 手动拒绝转账
     */
    void rejectTrans(ManualTransReq req);

    /**
     * 标记为已退
     * @param req
     */
    void markTrans(ManualTransReq req);

    /**
     * 查询历史提交批次
     * @param req
     * @return
     */
    TransBatchListQueryResp queryTransBatchList(TransBatchListQuery req);

    /**
     * 查询转账批次,详情
     * @param req
     * @return
     */
    TransBatchItemQueryResp queryTransBatchItems(TransBatchItemQuery req);
}
