package cn.kinyun.pay.business.service;

import cn.kinyun.pay.business.dto.request.audit.AuditResultReq;
import cn.kinyun.pay.business.dto.request.audit.refund.*;
import cn.kinyun.pay.business.dto.response.AuditResult;

import java.util.List;

public interface PayRefundAuditService {

    /**
     * 查询退款单
     *
     * @param query
     * @return
     */
    RefundListResp refundList(RefundListReq query);

    /**
     * 批次退款计算接口, 用于计算总金额,总退款笔数
     *
     * @param req
     * @return
     */
    RefundCalDto calRefund(PayRefundCalReq req);

    /**
     * 手动确认退款
     *
     * @param req
     * @param operatorId
     */
    void manualRefund(ManualRefundReq req, Long operatorId);

    /**
     * 拒绝退款
     * @param req
     * @param operatorId
     */
    void rejectRefund(ManualRefundReq req, Long operatorId);

    /**
     * 标记为已退款(通过其他渠道已经退款的)
     * @param req
     * @param operatorId
     */
    void markRefund(ManualRefundReq req, Long operatorId);

    /**
     * 发送验证码
     *
     * @param corpId
     * @param userId
     * @param weworkUserId
     * @param mobile
     */
    void sendVerifyCode(String corpId, Long userId, String weworkUserId, String mobile);

    /**
     * 批次退款列表查询
     *
     * @param req
     * @return
     */
    RefundBatchQueryResp refundBatchList(RefundBatchQuery req);

    /**
     * 批次退款明细查询
     *
     * @param req
     * @return
     */
    RefundDetailQueryResp refundBatchDetail(RefundDetailQuery req);

    /**
     * 根据退款单号查询退款单信息
     *
     * @param req
     * @return
     */
    List<AuditResult> queryAuditResult(AuditResultReq req);
}
