package cn.kinyun.pay.business.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 证书ID类型
 */
public enum BizIdType {
    MCHID(0, "商户ID"),

    APPID(1, "应用ID"),

    ;

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    BizIdType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static Map<Integer, BizIdType> MAP;

    static {
        MAP = Arrays.stream(BizIdType.values()).collect(Collectors.toMap(a -> a.getType(), a -> a));
    }

    public static BizIdType getByType(Integer type) {
        return MAP.get(type);
    }
}
