package cn.kinyun.pay.business.dto.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@SuppressWarnings({"java:S1948"})
@Data
public class TransWrongAccountDto implements Serializable {

    /**
     * 错误的账号信息
     * accountType = 0时, 实体为: {@link cn.kinyun.pay.business.dto.request.trans.BankCardAccount}
     * <p>
     * accountType = 1时, 实体为: {@link cn.kinyun.pay.business.dto.request.trans.AliPayAccount}
     * <p>
     * accountType = 2时, 实体为: {@link cn.kinyun.pay.business.dto.request.trans.WXPayAccount}
     */
    private Map<String, Object> accountMap;

    /**
     * 账户类型
     * <p>
     * {@link cn.kinyun.pay.business.enums.PayeeAccountType}
     */
    private Integer accountType;
}
