package cn.kinyun.pay.business.dto.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 退款单退款明细
 */
@SuppressWarnings({"common-java:DuplicatedBlocks"})
@Data
public class RefundDetailDto implements Serializable {

    private static final long serialVersionUID = -5291005326195826567L;

    /**
     * 退款类型; 0:退款;1:转账
     *
     * {@link cn.kinyun.pay.business.enums.RefundDetailType}
     */
    private Integer type;
    /**
     * 支付中心订单号
     */
    private String orderNum;
    /**
     * 第三方订单号
     */
    private String outOrderNum;
    /**
     * 支付中心退款单号
     */
    private String refundNum;
    /**
     * 第三方系统退款单号
     */
    private String outRefundNum;
    /**
     * 支付中心转账单号
     */
    private String transNum;
    /**
     * 第三方系统转账单号
     */
    private String outTransNum;
    /**
     * 退款渠道
     */
    private Integer channelType;
    /**
     * 转账渠道
     */
    private Integer transChannelType;
    /**
     * 退款金额 / 转账金额
     */
    private BigDecimal amount;
    /**
     * 退款时间 / 转账成功时间
     */
    private Date succDate;
}
