package cn.kinyun.pay.business.dto.request.audit.trans;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Data
public class TransListQueryReq implements Serializable {

    private String corpId;
    /**
     * 业务转账单号模糊查询
     */
    private String bizTransQuery;
    /**
     * 转账单号模糊查询
     */
    private String transQuery;
    /**
     * 选择的状态
     */
    private List<Integer> statusList;
    /**
     * 接收人,姓名/电话模糊查询
     */
    private String receiveQuery;
    /**
     * 转账类型
     */
    private Integer transChannelType;
    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;
    /**
     * 选中的转账单号
     */
    private List<String> selectedRequestId;

    private PageDto pageDto;

    private List<String> bizTransNums;

    private List<String> excludeCorpIds;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId不能为空");
    }
}
