package cn.kinyun.pay.business.dto.request.audit.trans;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@SuppressWarnings({"common-java:DuplicatedBlocks"})
@Data
public class TransItemDto implements Serializable {

    private String appId;
    /**
     * 批次单号(可能为空)
     */
    private String batchNum;
    /**
     * 请求ID
     */
    private String requestId;
    /**
     * 业务转账单号
     */
    private String bizTransNum;
    /**
     * 转账ID
     */
    private Long transId;
    /**
     * 支付中心转账单号
     */
    private String transNum;
    /**
     * 第三方转账单号
     */
    private String outTransNum;
    /**
     * 转账类型
     */
    private Integer transType;
    /**
     * 转账类型描述
     */
    private String transTypeDesc;
    /**
     * 转账状态
     */
    private Integer status;
    /**
     * 转账状态描述
     */
    private String statusDesc;
    /**
     * 接收账户名
     */
    private String receiveAccount;
    /**
     * 接收账户人姓名
     */
    private String receiveName;
    /**
     * 接收账户手机号
     */
    private String receivePhoneNum;
    /**
     * 转账金额
     */
    private BigDecimal transAmount;
    /**
     * 备注
     */
    private String remark;
    /**
     * 转账成功时间
     */
    private Date successTime;
    /**
     * 第三方返回状态
     */
    private String thirdPartStatus;
    /**
     * 第三方返回消息描述
     */
    private String thirdPartMsg;
    /**
     * 操作人ID
     */
    private Long operatorId;
    /**
     * 操作人姓名
     */
    private String operatorName;

    private Date createTime;

}
