package cn.kinyun.pay.business.dto.request.audit.trans;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

@Data
public class TransBatchItemQuery implements Serializable {

    private String corpId;
    /**
     * 转账批次号
     */
    private String transBatchNum;
    /**
     * 转账状态
     */
    private List<Integer> transStatusList;

    private PageDto pageDto;

    private List<String> excludeCorpIds;

    public void validate(){
        Preconditions.checkArgument(StringUtils.isNotBlank(transBatchNum), "批次号不能为空");
    }
}
