package cn.kinyun.pay.business.dto.request.audit.refund;

import cn.kinyun.pay.business.status.RefundHeaderStatus;
import cn.kinyun.pay.business.status.RefundStatus;
import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Data
public class RefundListReq implements Serializable {

    private String corpId;

    /**
     * 业务退款单号模糊查询
     */
    private String bizRefundNumQuery;
    /**
     * 业务订单号模糊查询
     */
    private String bizOrderNumQuery;
    /**
     * 退款状态列表
     */
    private List<Integer> refundStatusList;
    /**
     * 退款方式列表
     */
    private List<Integer> refundTypeList;
    /**
     * 客户姓名或电话
     */
    private String phoneQuery;
    /**
     * 批次号
     */
    private String batchNumQuery;
    /**
     * 创建时间开始时间
     */
    private Date startTime;
    /**
     * 创建时间结束时间
     */
    private Date endTime;
    /**
     * 选中的bizRefundNums
     */
    private List<String> bizRefundNums;

    private List<String> bizOrderNums;

    private PageDto pageDto;

    private List<String> excludeBizCorpIds;

    public void validate() {
        if (CollectionUtils.isNotEmpty(refundStatusList)) {
            for (Integer refundStatus : refundStatusList) {
                Preconditions.checkArgument(Objects.nonNull(RefundHeaderStatus.get(refundStatus)), "refundStatusList中状态非法");
            }
        }
    }
}
