package cn.kinyun.pay.business.dto.request.audit.refund;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

@Data
public class RefundDetailQuery implements Serializable {

    private String cropId;

    private String refundBatchNum;

    private String bizRefundNumQuery;

    private List<Integer> refundStatusList;

    private PageDto pageDto;

    private List<String> excludeCorpIds;

    public void validate(){
        Preconditions.checkArgument(StringUtils.isNotBlank(refundBatchNum), "批次号不能为空");

    }
}
