package cn.kinyun.pay.business.dto.request.audit.refund;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@SuppressWarnings({"common-java:DuplicatedBlocks"})
@Data
public class RefundDetailItem implements Serializable {
    /**
     * 退款单编号
     */
    private String bizRefundNum;
    /**
     * 订单编号
     */
    private String bizOrderNum;
    /**
     * 客户电话
     */
    private String phone;
    /**
     * 退款金额
     */
    private BigDecimal totalAmount;
    /**
     * 实退金额
     */
    private BigDecimal successAmount;
    /**
     * 退款方式
     */
    private Integer refundType;
    /**
     * 退款状态
     */
    private Integer refundStatus;
    /**
     * 退款状态详情
     */
    private String refundStatusDesc;
    /**
     * 退款原因
     */
    private String reason;
    /**
     * 数据来源
     */
    private Integer source;

    /**
     * 具体退款支付详情
     */
    private List<PayRefundDetail> payRefundDetails;
}
