package cn.kinyun.pay.business.dto.request.audit.refund;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

@ToString(callSuper = true)
@Data
public class PayRefundCalReq implements Serializable {

    private String corpId;

    /**
     * 退款查询条件
     */
    private RefundListReq query;
    /**
     * 选择模式:
     * 0: 勾选
     * 1: 根据条件全选所有
     * 2: 根据条件全选当前页
     */
    private Integer selectMode;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId不能为空");
        Preconditions.checkArgument(selectMode == null || (selectMode >= 0 && selectMode <= 2), "选择模式必须在0,2之间");
        if (Objects.isNull(selectMode) || selectMode == 0) {
            selectMode = 0;
            Preconditions.checkArgument(Objects.nonNull(query), "query不能为空");
            Preconditions.checkArgument(CollectionUtils.isNotEmpty(query.getBizRefundNums()), "勾选模式下,bizRefundNums不能为空");
        } else {
            Preconditions.checkArgument(Objects.nonNull(query), "query不能为空");
            query.validate();
        }
    }
}
