package cn.kinyun.pay.business.dto.request.audit.refund;

import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@SuppressWarnings({"common-java:DuplicatedBlocks"})
@ToString(callSuper = true)
@Data
public class ManualRefundReq extends PayRefundCalReq implements Serializable {

    private String smsVerify;

    private String remark;

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument(StringUtils.isNotBlank(smsVerify), "短信验证码为空");
        if (StringUtils.isNotBlank(remark)) {
            Preconditions.checkArgument(remark.length() < 500, "备注需在500字以内");
        }
    }

    public void rejectValidate(){
        super.validate();
        if (StringUtils.isNotBlank(remark)) {
            Preconditions.checkArgument(remark.length() < 500, "备注需在500字以内");
        }
    }
}
