package cn.kinyun.pay.business.dto.request.audit;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

@Data
public class AuditResultReq implements Serializable {
    /**
     * bizRefundNum或bizTransNum
     */
    private List<String> bizRefundNums;

    public void validate() {
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(bizRefundNums), "bizRefundNums is null or empty");
        for (String bizRefundNum : bizRefundNums) {
            Preconditions.checkArgument(StringUtils.isNotEmpty(bizRefundNum), "bizRefundNums item is null or empty");
        }
    }
}
