package cn.kinyun.pay.business.dto.request;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * author: jw
 * date: 2022/4/29 下午5:56
 * content:
 */
@Data
public class ScrmPayConfigDto implements Serializable {
    private Long bizId;

    private Integer isDeleted;

    private String corpId;

    private String corpName;

    private String payType;

    private String payId;

    private String paySecret;

    private String payCertUrl;

    private String appId;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "商户id不能为空");
        Preconditions.checkArgument(isDeleted != null && (isDeleted == 0 || isDeleted == 1));

        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId不能为空");

        Preconditions.checkArgument(StringUtils.isNotBlank(payType), "支付方式不能为空");
        if (isDeleted == 0) {
            Preconditions.checkArgument(StringUtils.isNotBlank(payId), "商户支付id不能为空");
            Preconditions.checkArgument(StringUtils.isNotBlank(paySecret), "商户支付秘钥d不能为空");

            Preconditions.checkArgument(StringUtils.isNotBlank(appId), "appId不能为空");
        }
    }
}
