package cn.kinyun.pay.business.dto.request;


import cn.kinyun.pay.business.enums.SourceType;
import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

import java.util.Objects;

/**
 * Created by jiangtiteng on 2019-01-04
 */
@Data
@ToString
public class RefundRequest extends BaseRequest {

    /**
     * 退款金额，单位为分
     */
    private String amount;

    /**
     * 业务退款单号
     */
    private String bizRefundNum;

    /**
     * 业务订单编号
     */
    private String bizOrderNum;

    /**
     * 退款原因
     */
    private String refundReason;

    /**
     * 来源 {@link SourceType}
     */
    private Integer sourceType;


    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument(StringUtils.isNotBlank(amount) && amount.matches("\\d+"), "无效的amount,金额必须以分为单位,且是一个正整数");
        Long totalAmountNum = NumberUtils.toLong(amount);
        Preconditions.checkArgument(totalAmountNum > 0 && totalAmountNum < 100000000000L, "amount取值范围为:[1,100000000000)");
        Preconditions.checkArgument(StringUtils.isNotBlank(bizRefundNum), "bizRefundNum 不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(bizOrderNum), "bizOrderNum 不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(refundReason), "refundReason 不能为空");
        if (Objects.isNull(sourceType)) {
            sourceType = SourceType.DEFAULT.getType();
        }
    }
}
