package cn.kinyun.pay.business.dto.request;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

@Data
public class RefundQueryReq implements Serializable {

    private String bizOrderNum;

    /**
     * 包含所有的业务转账编码, 即bizOrderNum对应的所有bizTransNum需要由业务系统传入，而bizRefundNum可以由refundHeader表查询得到，所以bizRefundNums可以不传
     */
    private List<String> bizTransNums;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(bizOrderNum), "bizOrderNum can not be null or empty");
        if (CollectionUtils.isEmpty(bizTransNums)) {
            bizTransNums = Lists.newArrayList();
        }
    }
}
