package cn.kinyun.pay.business.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
public class PayConfigGroupReq extends PayConfigBaseReq {

    private String groupKey;

    private Integer channelType;

    private PageDto pageDto;

    public void validate() {
        super.validate();
        Preconditions.checkArgument(StringUtils.isNotBlank(groupKey), "groupKey is null or empty");
    }
}
