package cn.kinyun.pay.business.dto.request;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@Data
public class PayConfigGroupAddReq extends PayConfigBaseReq implements Serializable {

    private String groupKey;

    /**
     * 分组名称
     */
    private String groupName;

    /**
     * 是否是默认分组
     */
    private Integer isDefault;

    /**
     * payCorpAppChannel表num列表
     */
    private List<String> payCorpAppChannelNums;

    /**
     * 操作人ID
     */
    private Long operatorId;

    public void validate() {
        super.validate();
        Preconditions.checkArgument(StringUtils.isNotBlank(groupName) && StringUtils.length(groupName) < 128, "groupName不能为空，且长度小于128字符");
        Preconditions.checkArgument(Objects.nonNull(isDefault) && isDefault >= 0 && isDefault <= 1, "isDefault 不能为空，且取值为0,1");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(payCorpAppChannelNums), "payCorpAppChannelNums不能为空");
        for (String payCorpAppChannelNum : payCorpAppChannelNums) {
            Preconditions.checkArgument(StringUtils.isNotBlank(payCorpAppChannelNum), "payCorpAppChannelNums有元素为空");
        }
        Preconditions.checkArgument(Objects.nonNull(operatorId), "operatorId is null");
    }
}
