package cn.kinyun.pay.business.dto.request;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class BaseRequest implements Serializable {
    /**
     * corpId
     */
    private String corpId;

    /**
     * 唯一请求id
     */
    private String requestId;

    /**
     * secret
     */
    private String secret;

    /**
     * sign
     */
    private String sign;

    public void validate() {
        Preconditions.checkNotNull(StringUtils.isNotEmpty(requestId), "requestId 不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(secret) || StringUtils.isNotBlank(sign), "sign 和 secret不能同时为空");
    }
}