package cn.kinyun.pay.business.status;

import com.google.common.collect.Sets;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@AllArgsConstructor
@Getter
public enum TransStatus {

    TRANS_REJECT(-2,"转账拒绝"),

    TRANS_STATUS_AUDIT(-1,"转账待审计"),
    /**
     * 一般用于退款一体接口插入的数据
     */
    TRANS_STATUS_DRAFT(0, "草稿"),

    TRANS_STATUS_DEALING(1, "处理中"),

    TRANS_STATUS_SUCC(2, "成功"),

    TRANS_STATUS_FAILED(3, "失败"),

    TRANS_STATUS_REFUNDED(4, "退票");

    private Integer value;

    private String desc;

    private static final Map<Integer, TransStatus> MAP;

    static {
        MAP = Arrays.stream(TransStatus.values()).collect(Collectors.toMap(a -> a.getValue(), a -> a));
    }

    public static TransStatus get(Integer value) {
        return MAP.get(value);
    }

    public static final Set<Integer> finalStatusSet = Sets.newHashSet(TRANS_STATUS_FAILED.getValue(), TRANS_STATUS_REFUNDED.getValue());

    public static Set<Integer> getFinalStatusSet() {
        return finalStatusSet;
    }
}
