package cn.kinyun.pay.business.event;

import lombok.Data;

import java.util.Date;

@Data
public class PayEvent {

    private String uniqueId;

    private String appId;
    /**
     * 业务订单编号
     */
    private String bizOrderNum;
    /**
     * 业务退款单号
     */
    private String bizRefundNum;
    /**
     * 业务转账单号
     */
    private String bizTransNum;
    /**
     * 事件类型
     * <p>
     * {@link cn.kinyun.pay.business.enums.PayEventType}
     */
    private Integer eventType;
    /**
     * 订单状态(bizOrderNum不为空时有用)
     */
    private Integer orderStatus;
    /**
     * 退款单号(bizRefundNum不为空时有用)
     */
    private Integer refundOrderStatus;
    /**
     * 事件发生时间
     */
    private Date eventTime;
    /**
     * 携带信息,后面会根据事件进行扩展
     * <p>
     * eventType=2时,即:转账账户信息有误时, body= {@link cn.kinyun.pay.business.dto.vo.TransWrongAccountDto}
     *
     * eventType=1,3,4,5时, body= {@link cn.kinyun.pay.business.dto.vo.ApproveResult}
     */
    private String body;
}
