package cn.kinyun.pay.business.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 收款人账号类型
 */
public enum PayeeAccountType {

    BANK_CARD(0, "银行卡号"),

    ALIPAY_ACCOUNT(1, "支付宝账号"),

    WEIXIN_ACCOUNT(2, "微信账号"),
    ;

    private Integer type;

    private String desc;

    PayeeAccountType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, PayeeAccountType> MAP;

    static {
        MAP = Arrays.stream(PayeeAccountType.values()).collect(Collectors.toMap(a -> a.getType(), a -> a));
    }

    public static PayeeAccountType getByType(Integer type) {
        return MAP.get(type);
    }
}
