package cn.kinyun.pay.business.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

@Getter
@AllArgsConstructor
public enum PayTransChannelType implements Serializable {
    PAY_TRANS_TYPE_ALILY_TO_ALILY(101, "通过支付宝转账到支付宝账号", "alipay"),

    PAY_TRANS_TYPE_WEIXIN_TO_WEIXIN(102, "通过微信支付转账", "weixin"),

    PAY_TRANS_TYPE_BANK_TO_BANK(103, "通过银行转账", "bank"),

    PAY_TRANS_TYPE_ALIPAY_TO_BANK(104,"通过支付宝转账到银行卡","alipay"),
    ;

    private Integer value;

    private String desc;

    private String serviceCode;


    private static final Map<Integer, PayTransChannelType> MAP;

    static {
        MAP = Arrays.stream(PayTransChannelType.values()).collect(Collectors.toMap(a -> a.getValue(), a -> a));
    }

    public static PayTransChannelType get(Integer value) {
        return MAP.get(value);
    }
}
